/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/* for RDMA */

#define MX_PAGE_SHIFT      13
#define MX_PAGE_SIZE       (1UL << MX_PAGE_SHIFT)
#define MX_PAGE_MASK          (~(MX_PAGE_SIZE-1))

#define MX_PGD_SHIFT       33
#define MX_PGD_MASK        0x3FF

#define MX_PMD_SHIFT       23
#define MX_PMD_MASK        0x3FF

#define MX_PTE_SHIFT       13
#define MX_PTE_MASK        0x3FF

#define MX_N_PGDENT        1024
#define MX_N_PMDENT        1024
#define MX_N_PTEENT        8192

#define MX_N_HNDL          1024
#define MX_PT_FLAG_MASK    3

#define MX_PGD_OFFSET(x)  (((x) >> MX_PGD_SHIFT) & MX_PGD_MASK)
#define MX_PMD_OFFSET(x)  (((x) >> MX_PMD_SHIFT) & MX_PMD_MASK)
#define MX_PTE_OFFSET(x)  (((x) >> MX_PTE_SHIFT) & MX_PTE_MASK)

typedef struct {
  unsigned long phys[MX_N_PTEENT];
  int count;
} mx_pte_t;

typedef struct {
  mx_pte_t *pte[MX_N_PMDENT];
  int count;
} mx_pmd_t;

typedef struct {
  mx_pmd_t *pmd[MX_N_PGDENT];
} mx_pgd_t;

struct mx_get_request {
  uint32_t handle;
  uint32_t offset;
  uint32_t len;
};

int mx_rdma_allowed(uint64_t, uint32_t, int);
void mx_rdma_allow(uint64_t, uint32_t, int);
void mx_rdma_disable(uint64_t, uint32_t, uint32_t);
uint32_t mx_add_window_handle(mx_endpoint_t, uint64_t, int, uint32_t);
void mx_del_window_handle(mx_endpoint_t, uint32_t);

mx_pgd_t mx_pt;


#define MX_PTR(i) ((void*)(uintptr_t)(i))
#define MX_UINT64(p) ((uint64_t)(uintptr_t)(p))
